<?php

/**
 *	Class Backup
 *  -------------- 
 *  Description : encapsulates backup operations & properties
 *  Updated	    : 20.05.2009
 *	Written by  : ApPHP
 *	
 **/

class Backup {
	
	public $error;
	
	protected $backupDirectory;
	protected $backupFilePrefix;
	protected $backupFileExt;	
	
	private $db;
	
	//==========================================================================
    // Class Constructor
	//==========================================================================
	function __construct(&$db = null)
	{
		$this->db = $db;
		$this->db->open();
		$this->backupDirectory = "../backup/";
		$this->backupFilePrefix = "db-backup-";
		$this->backupFileExt = ".sql"; 
	}
	
	//==========================================================================
    // Class Destructor
	//==========================================================================
    function __destruct()
	{
		// echo 'this object has been destroyed';
    }

	/***
	 * 	Show list of previouse backups
	 * 		@param $link_type - type of link
	 **/
	function ShowPreviouseBackups($link_type = "delete")
	{
		function DateCompare($a, $b){
			return ($a[1] <= $b[1]) ? 0 : 1;
		}
	
		$files = array();
		if (!file_exists($this->backupDirectory)) { mkdir($this->backupDirectory,0755); }
		if ($handle = opendir($this->backupDirectory)){
			// loop over the directory
			while (false !== ($file = readdir($handle))) {
				if(preg_match('/'.$this->backupFilePrefix.'/', $file) && preg_match('/.zip/', $file)){	
					$files[] = array($file, time() - filemtime($this->backupDirectory.$file), filesize($this->backupDirectory.$file));
				}
			}		
			closedir($handle);
		}		
		
		// sort files by date
		usort($files, 'DateCompare');

		foreach($files as $key => $val){
			$fname = str_replace(array($this->backupFilePrefix, $this->backupFileExt), "", $val[0]);
			echo "<tr><td>&nbsp;</td><td>".$val[0]."</td><td align='center'>".number_format(($val[2]/1024), 0, ".", ",")." KB</td>";
			if($link_type == "delete"){
				echo "<td>&nbsp;</td><td><a href='backup.php?st=delete&fname=".$fname."' onclick='return confirm(\"Are you sure you want to delete this backup?\")'>[Delete]</a></td><td>&nbsp;</td></tr>";				
			}else if($link_type == "restore"){
				echo "<td>&nbsp;</td><td><a href='backup.php?st=restore&fname=".$fname."' onclick='return confirm(\"Are you sure you want to restore this backup?\")'>[Restore]</a></td><td>&nbsp;</td></tr>";				
			}else if($link_type == "delete,restore"){
				echo "<td>&nbsp;</td>
					  <td nowrap>
						  <a href='backup.php?st=delete&fname=".$fname."' onclick='return confirm(\"Are you sure you want to delete this backup \\n(".$fname.")?\")'>[Delete]</a>
						  <a href='backup.php?st=restore&fname=".$fname."' onclick='return confirm(\"Are you sure you want to restore this backup \\n(".$fname.")?\")'>[Restore]</a>
					  </td>
					  <td>&nbsp;</td>
					  </tr>";				
			}else{
				echo "";				
			}
		}
		
		if(count($files) == 0){
			echo "<tr><td colspan='2'>There are no backups yet.</td></tr>";
		}		
	}

	/***
	 * 	Delete backup file
	 * 		@param $backup_file - backup file name
	 **/
	function DeleteBackup($backup_file = "")
	{
        // block all operations on demo version
		if(strtolower(_SITE_MODE) == "demo"){
			$this->error = "This operation is blocked in Demo Version!";
			return false;				
		}
        
		$backup_file = $this->backupDirectory.$this->backupFilePrefix.$backup_file.$this->backupFileExt;
		
		if($backup_file == ""){
			$this->error = "Backup file name can not be empty! Please re-enter.";
			return false;
		}
		
        if(@unlink($backup_file)){
            return true;		
        }else{
            $this->error = "An error occured while deleting file! Please try again later.";
            return false;
        }
	}

	/***
	 * 	Restore backup the db OR just a table
	 * 		@param $backup_file - backup file name
	 **/
	function RestoreBackup($backup_file = "")
	{
        // block all operations on demo version
		if(strtolower(_SITE_MODE) == "demo"){
			$this->error = "This operation is blocked in Demo Version!";
			return false;				
		}

		$backup_file = $this->backupDirectory.$this->backupFilePrefix.$backup_file.$this->backupFileExt;

		if($backup_file == ""){
			$this->error = "Backup file name can not be empty! Please re-enter.";
			return false;
		}
		
        $sql_dump = @file_get_contents($backup_file);
        if ($this->ExecuteSqlDump($sql_dump)){
            return true;
        }else{
            $this->error = "An error occured while restoring file! Please try again later.";
            return false;
        }
	}

	/***
	 * 	Execute backup the db OR just a table
	 * 		@param $backup_file - backup file name
	 * 		@param $tables - teables to backup
	 **/
	function ExecuteBackup($backup_file = "", $tables = '*')
	{
        // block all operations on demo version
		if(strtolower(_SITE_MODE) == "demo"){
			$this->error = "This operation is blocked in Demo Version!";
			return false;				
		}

		if($backup_file == ""){
			$this->error = "Backup file name can not be empty! Please re-enter.";
			return false;
		}
		
        // save all tables
        if($tables == '*'){
            $tables = array();			
            $result = $this->db->query("SHOW TABLES");
            while($r__ = $this->db->fetchArray()){
				$tables[] = $r__[0];
			}
        }else{
            $tables = is_array($tables) ? $tables : explode(',',$tables);
        }
        
        // run cycle through
		$return = "";
        foreach($tables as $table){
            $this->db->query("SELECT * FROM ".$table);
			$num_fields = $this->db->numCols();
			
            $return .= "DROP TABLE IF EXISTS ".$table.";";
            $this->db->query("SHOW CREATE TABLE ".$table);
			$r__ = $this->db->fetchArray();
            $return .= "\n\n".$r__[1].";\n\n";
            
            $this->db->query("SELECT * FROM ".$table);
            while($r__ = $this->db->fetchArray()){
                $return.= "INSERT INTO ".$table." VALUES(";
                for($j=0; $j<$num_fields; $j++) 
                {
                    $row[$j] = addslashes($r__[$j]);
					$row[$j] = preg_replace("/\n/", "\\n",$r__[$j]);
                    if (isset($r__[$j])) { $return.= '"'.$r__[$j].'"' ; } else { $return.= '""'; }
                    if ($j<($num_fields-1)) { $return.= ','; }
                }
                $return.= ");\n";
            }
            $return.="\n\n\n";
        }
        
        $backup_file_name = ($backup_file == "") ? date("M-d-Y") : $backup_file;
        $backup_file_path = $this->backupDirectory.$this->backupFilePrefix.$backup_file_name.$this->backupFileExt;
        
        //save file
        @chmod($backup_file_path, 0755);
        $handle = fopen($backup_file_path,'w+');
        if($handle){
            fwrite($handle,$return);
            fclose($handle);
            $result = true;
        }else{
            $this->error = BACKUP_EXECUTING_ERROR;
            $result = false;
        }
        @chmod($backup_file_path, 0644);
        return $result;
	}

	
	/***
	 * 	Execute SqlDump
	 * 		@param $restore_query - resore query or list of queries
	 **/
	private function ExecuteSqlDump($restore_query)
	{    	
		$sql_array = array();
		$sql_length = strlen($restore_query);
		$pos = strpos($restore_query, ';');
		for ($i=$pos; $i<$sql_length; $i++) {
			if ($restore_query[0] == '#') {
				$restore_query = ltrim(substr($restore_query, strpos($restore_query, "\n")));
				$sql_length = strlen($restore_query);
				$i = strpos($restore_query, ';')-1;
				continue;
			}
			if ($restore_query[($i+1)] == "\n") {
				for ($j=($i+2); $j<$sql_length; $j++) {
					if (trim($restore_query[$j]) != '') {
						$next = substr($restore_query, $j, 6);
						if ($next[0] == '#') {
							// remove line  where the break position (#comment line)
							for ($k=$j; $k<$sql_length; $k++) {
								if ($restore_query[$k] == "\n") break;
							}
							$query = substr($restore_query, 0, $i+1);
							$restore_query = substr($restore_query, $k);
							// join 2 parts of query
							$restore_query = $query . $restore_query;
							$sql_length = strlen($restore_query);
							$i = strpos($restore_query, ';')-1;
							continue 2;
						}
						break;
					}
				}
				if ($next == '') { // get last insert query
					$next = 'insert';
				}
				if ( (preg_match('/create/i', $next)) || (preg_match('/insert/i', $next)) || (preg_match('/drop t/i', $next)) ) {
					$next = '';
					$sql_array[] = substr($restore_query, 0, $i);
					$restore_query = ltrim(substr($restore_query, $i+1));
					$sql_length = strlen($restore_query);
					$i = strpos($restore_query, ';')-1;
				}
			}
		}
	
		for ($i=0; $i<sizeof($sql_array); $i++) {
			if(!@$this->db->query($sql_array[$i])) return false;
		}
		
		return true;	
	}

}
