<?php

//--------------------------------------------------------------------------
// set browser definitions
//--------------------------------------------------------------------------
function setBrowserDefinitions(){
    $bd = array();
    
    $agent = $_SERVER['HTTP_USER_AGENT'];
    // initialize properties
    $bd['platform'] = 'Windows';
    $bd['browser'] = 'MSIE';
    $bd['version'] = '6.0';    
      
    // find operating system
    if (preg_match('/win/i', $agent))       $bd['platform'] = 'Windows';
    elseif (preg_match('/mac/i', $agent))   $bd['platform'] = 'MacIntosh';
    elseif (preg_match('/linux/i', $agent)) $bd['platform'] = 'Linux';
    elseif (preg_match('/OS\/2/i', $agent))  $bd['platform'] = 'OS/2';
    elseif (preg_match('/BeOS/i', $agent))  $bd['platform'] = 'BeOS';
    
    // test for Opera
    if (preg_match('/opera/i',$agent)){
        $val = stristr($agent, 'opera');
        if (preg_match('/\//i', $val)){
            $val = explode('/',$val); $bd['browser'] = $val[0]; $val = explode(' ',$val[1]); $bd['version'] = $val[0];
        }else{
            $val = explode(' ',stristr($val,'opera')); $bd['browser'] = $val[0]; $bd['version'] = $val[1];
        }
    // test for MS Internet Explorer version 1
    }elseif(preg_match('/microsoft internet explorer/i', $agent)){
        $bd['browser'] = 'MSIE'; $bd['version'] = '1.0'; $var = stristr($agent, '/');
        if (preg_match('/308|425|426|474|0b1/i', $var)) $bd['version'] = '1.5';
    // test for MS Internet Explorer
    }elseif(preg_match('/msie/i',$agent) && !preg_match('/opera/i',$agent)){
        $val = explode(' ',stristr($agent,'msie')); $bd['browser'] = $val[0]; $bd['version'] = $val[1];
    // test for MS Pocket Internet Explorer
    }elseif(preg_match('/mspie/i',$agent) || preg_match('/pocket/i', $agent)){
        $val = explode(' ',stristr($agent,'mspie')); $bd['browser'] = 'MSPIE'; $bd['platform'] = 'WindowsCE';
        if (preg_match('/mspie/i', $agent))
            $bd['version'] = $val[1];
        else {
            $val = explode('/',$agent);     $bd['version'] = $val[1];
        }
    // test for Firebird
    }elseif(preg_match('/firebird/i', $agent)){
        $bd['browser']='Firebird'; $val = stristr($agent, 'Firebird'); $val = explode('/',$val); $bd['version'] = $val[1];
    // test for Firefox
    }elseif(preg_match('/Firefox/i', $agent)){
        $bd['browser']='Firefox'; $val = stristr($agent, 'Firefox'); $val = explode('/',$val); $bd['version'] = isset($val[1]) ? $val[1] : '';
    // test for Mozilla Alpha/Beta Versions
    }elseif(preg_match('/mozilla/i',$agent) && preg_match('/rv:[0-9].[0-9][a-b]/i',$agent) && !preg_match('/netscape/i',$agent)){
        $bd['browser'] = 'Mozilla'; $val = explode(' ',stristr($agent,'rv:')); preg_match('/rv:[0-9].[0-9][a-b]/i',$agent,$val); $bd['version'] = str_replace('rv:','',$val[0]);
    // test for Mozilla Stable Versions
    }elseif(preg_match('/mozilla/i',$agent) && preg_match('/rv:[0-9]\.[0-9]/i',$agent) && !preg_match('/netscape/i',$agent)){
        $bd['browser'] = 'Mozilla'; $val = explode(' ',stristr($agent,'rv:')); preg_match('/rv:[0-9]\.[0-9]\.[0-9]/i',$agent,$val); $bd['version'] = str_replace('rv:','',$val[0]);
    // remaining two tests are for Netscape
    }elseif(preg_match('/netscape/i',$agent)){
        $val = explode(' ',stristr($agent,'netscape')); $val = explode('/',$val[0]); $bd['browser'] = $val[0]; $bd['version'] = $val[1];
    }elseif(preg_match('/mozilla/i',$agent) && !preg_match('/rv:[0-9]\.[0-9]\.[0-9]/i',$agent)){
        $val = explode(' ',stristr($agent,'mozilla')); $val = explode('/',$val[0]); $bd['browser'] = 'Netscape'; $bd['version'] = $val[1];
    }
    // clean up extraneous garbage that may be in the name
    $bd['browser'] = preg_replace('/[^a-z,A-Z]/', '', $bd['browser']);
    $bd['version'] = preg_replace('/[^0-9,.,a-z,A-Z]/', '', $bd['version']);
    
    return $bd;
}
    
function removeBadChars($strWords){
	$bad_string = array("select", "drop", ";", "--", "insert","delete", "xp_", "%20union%20", "/*", "*/union/*", "+union+", "load_file", "outfile", "document.cookie", "onmouse", "<script", "<iframe", "<applet", "<meta", "<style", "<form", "<img", "<body", "<link", "_GLOBALS", "_REQUEST", "_GET", "_POST", "include_path", "prefix", "http://", "https://", "ftp://", "smb://" );
	for ($i = 0; $i < count($bad_string); $i++){
		$strWords = str_replace ($bad_string[$i], "", $strWords);
	}
	return $strWords;
}

function stripQuotes($strWords){
	return str_replace("'", "''", $strWords);
}


function read_directory_subfolders($dir = "."){
	$folder=dir($dir); 
	$arrFolderEntries = array();
	while($folderEntry=$folder->read()){ 
		if($folderEntry != '.' && $folderEntry != '..' && is_dir($dir.$folderEntry)) 
			$arrFolderEntries[] = $folderEntry; 
	}     
	$folder->close(); 
	return $arrFolderEntries;
}


/**
 *	Draws messages 
 *      @param $type - message type: normal|error|success
 *  	@param $message - message text
 *      @param $is_draw
 **/
function draw_message($type="normal", $message, $is_draw=true, $width="100%", $dir="")
{        
	if($type == "success"){
		$table_class = "success_message_box";
		$message_sign = "success_sign.gif";
	}else if($type == "error"){
		$table_class = "important_message_box";
		$message_sign = "error_sign.gif";
	}else{
		$table_class = "message_box";
		$message_sign = "attention_sign.gif";
	}
	if (!empty($message)) $message = "<table width='".$width."' align='center' class='".$table_class."' border='0'><tr><td class='message_sign'><img align='center' src='".$dir."images/".$message_sign."' alt=''></td><td class='message_text'>".$message."</td></tr></table>";
	if(!$is_draw) return $message;
	else echo $message;	
}    

/**
 *	Returns formated dataime by mask
 *      @param $datetime - datetime to be formated
 *  	@param $mask - datetime mask
 **/
function my_date_format($datetime, $mask="M d, Y g:i A")
{       
	$mktime = mktime(substr($datetime, 11, 2), substr($datetime, 14, 2),
					substr($datetime, 17, 2), substr($datetime, 5, 2),
					substr($datetime, 8, 2), substr($datetime, 0, 4));
 
	if($datetime != ""){
		return date($mask, $mktime);
	}
	
	return "";
}


/**
 *  Prepare input
 *      @param $input
 *      @param $validation_type
 *      @param $possible_values
 *      @param $level
 */
function prepare_input($input, $validation_type = '', $possible_values = '', $level = 'medium')
{
    $output = '';
    if($level == 'medium'){
        $output = strip_tags($input);
    }
    
    //$possible_values = array('([^0-9px])','([^0-9%])');
    //$with = array('');
    if($validation_type == 'custom'){
        $output = preg_replace('/'.$possible_values.'/', '', $input);
    }
    
    #if(is_array($possible_values) && !empty($possible_values)){
    #    if(in_array($output)) return $output;
    #    else return '';
    #}
    return $output;
}
