<?php
################################################################################
##              -= YOU MAY NOT REMOVE OR CHANGE THIS NOTICE =-                 #
## --------------------------------------------------------------------------- #
##  ApPHP AdminPanel Basic version                                             #
##  Developed by:  ApPHP <info@apphp.com>                                      # 
##  License:       GNU GPL v.2                                                 #
##  Site:          https://www.apphp.com/php-adminpanel/                       #
##  Copyright:     ApPHP AdminPanel (c) 2006-2017. All rights reserved.        #
##                                                                             #
##  Additional modules (embedded):                                             #
##  -- PHP DataGrid v5.0.7 (datagrid component)              https://apphp.com #
##  -- PHP Easy Installer v2.0.2 (installation module)       https://apphp.com #
##  -- JA Auto Form Validator v1.0.5 (JS Validator)          https://apphp.com #
##  -- jQuery v1.1.2 (JS Library)                            http://jquery.com #
##  -- Crystal Project Icons (icons set)               http://www.everaldo.com #
##  -- Drop Bown Menu - Head Script                  copyright Stephen Chapman #
##                                                                             #
################################################################################

//------------------------------------------------------------------------------
// check if Admin Panel was already installed
if (!file_exists("inc/config.inc.php")) {
	header("location: install.php");
}
//------------------------------------------------------------------------------
	
    session_start();

    // After this number of seconds, stored data will be seen as 'garbage' and
    // cleaned up by the garbage collection process.
    // session.gc_maxlifetime = 1440
    ini_set("session.gc_maxlifetime","3600");
    
    require_once("inc/config.inc.php");
    require_once("inc/settings.inc.php");
    
    $adm_logged 	= (isset($_SESSION['adm_logged'])) ? $_SESSION['adm_logged'] : false;
	$log 			= (isset($_REQUEST['log'])) ? "out" : "";
    $msg 			= (isset($_REQUEST['msg'])) ? $_REQUEST['msg'] : "";

    if($adm_logged == true){
		$menu_page = "left_menu.php";
		$top_menu_page = "top_menu.php";
		$content_page = "panel_pages/home.php";
		$left_menu_bar = "left_menu_bar.php";
    }else{		
		$menu_page = "left_menu_empty.php";
		$top_menu_page = "top_menu.php";
		$content_page = "login.php";		
    }

  
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title><?php echo $SETTINGS['site_name']; ?> :: Admin Panel</title>
	
    <!-- CSS style files -->
    <link href="styles/<?php echo $SETTINGS['css_style'];?>/style.css" type=text/css rel=stylesheet>
	<link rel="SHORTCUT ICON" href="images/apphp.ico"/>
	
    <!-- Meta tags -->    
    <meta http-equiv=Content-Type content="text/html; charset=utf-8">

    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="expires" content="0">

    <!-- JavaScript files -->
    <script type="text/JavaScript" src="js/functions.js"></script>
	
	<?php if($adm_logged == true){ ?>
	<script type="text/JavaScript">
		
		var default_session_timeout = 60*<?php echo (int)$SETTINGS['session_timeout']; ?>; // in sec
		var minimal_timeout_value = default_session_timeout/10; // in sec
		var session_timeout = default_session_timeout; // in sec
		var delaytime = 30000; // in msec
		
		function checkSessionTimeout()
		{				
		    session_timeout = session_timeout - delaytime/1000;
			if(session_timeout < 0){
				document.location.href = "logout.php";
			}else if(session_timeout < minimal_timeout_value){
				if(document.getElementById("frameMain")){
					document.getElementById("frameMain").src = "panel_pages/timeout.php";
				}else if(document.getElementById("top_menu")){
					window.frames["top_menu"].showTimeOutPage();
				}			    
			}else{
				// session not expired yet
			}
			setTimeout("checkSessionTimeout()", delaytime); 
		}
		
		function resetSessionTimeout(){
			session_timeout = default_session_timeout;			
		}
		
		setTimeout("checkSessionTimeout()", delaytime); 
	</script>
	<?php } ?>
</head>
<?php if($SETTINGS['menu_style'] == "left"){ ?>
<frameset rows="60px,*" FRAMEBORDER="no" FRAMESPACING="0" BORDER="0">
    <frame src="header.php" name="header" scrolling="no">
	<?php if($adm_logged == true){	?>
    <frameset id="mainFrame" cols="170px,10px,*" frameborder="no" framespacing="0" border="0">
        <frame src="<?php echo $menu_page; ?>" name="left_menu" noresize scrolling="no" border="0">
        <frame src="<?php echo $left_menu_bar; ?>" name="left_menu_bar" noresize scrolling="no" border="0">
        <frame src="<?php echo $content_page; ?>" id="frameMain" name="frameMain" noresize BORDER="0">
    </frameset>
	<?php }else{ ?>    
        <frame src="<?php echo $content_page; ?>" id="frameMain" name="frameMain" noresize border="0">    
	<?php } ?>
</frameset>
<?php
}else{
    if($adm_logged != true) $top_menu_page = "login.php";
?>
<frameset rows="60px,*" frameborder="no" framespacing="0" border="0">
    <frame z-index="1" src="header.php" name="header" scrolling="no">
    <frame z-index="10000" src="<?php echo $top_menu_page; ?>?page=<?php echo $content_page;?>" name="top_menu" scrolling="no">     
</frameset>
<?php
}
?>
</html>
<!-- This script was generated by PHPAP (ApPHP AdminPanel) v.<?php echo _PHP_AP_VERSION; ?> -->