DROP TABLE IF EXISTS <DB_PREFIX>admins;
CREATE TABLE `<DB_PREFIX>admins` (
  `id` int(10) NOT NULL auto_increment,
  `username` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `last_name` varchar(50) character set utf8 NOT NULL,
  `first_name` varchar(50) character set utf8 NOT NULL,
  `email` varchar(50) NOT NULL default '',
  `last_login` datetime NULL DEFAULT NULL,
  `status` enum('main admin','admin') NOT NULL default 'main admin',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>admins VALUES(1, "<USER_NAME>", "<PASSWORD>" ,"Smith", "John", "admin@domain.com", "2017-09-04 01:38:12", "main admin");


DROP TABLE IF EXISTS <DB_PREFIX>datagrid_pages;
CREATE TABLE `<DB_PREFIX>datagrid_pages` (
  `id` int(10) NOT NULL auto_increment,
  `menu_id` int(10) NOT NULL default '0',
  `page_header` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>datagrid_pages VALUES(1,"14","");


DROP TABLE IF EXISTS <DB_PREFIX>dynamic_pages;
CREATE TABLE `<DB_PREFIX>dynamic_pages` (
  `id` int(10) NOT NULL auto_increment,
  `menu_id` int(10) NOT NULL default '0',
  `page_header` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>dynamic_pages VALUES("8","13","");


DROP TABLE IF EXISTS <DB_PREFIX>file_types;
CREATE TABLE `<DB_PREFIX>file_types` (
  `id` tinyint(3) NOT NULL,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>file_types VALUES("1","Static page");
INSERT INTO <DB_PREFIX>file_types VALUES("2","PHP simple page");
INSERT INTO <DB_PREFIX>file_types VALUES("3","PHP DataGrid page");


DROP TABLE IF EXISTS <DB_PREFIX>menu;
CREATE TABLE `<DB_PREFIX>menu` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `page_name` varchar(30) NOT NULL default '',
  `is_menu_group` tinyint(1) NOT NULL default '0',
  `is_removable` tinyint(1) NOT NULL default '0',
  `is_hidden` tinyint(1) NOT NULL default '0',
  `parent_id` int(11) NOT NULL default '0',
  `order_index` tinyint(3) NOT NULL default '0',
  `icon` varchar(30) default NULL,
  `is_dashboard_icon` tinyint(1) default '1',
  `is_menu_item` tinyint(1) NOT NULL default '1',
  `is_create_file` tinyint(1) NOT NULL default '1',
  `file_type_id` tinyint(3) NOT NULL default '2',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `is_menu_name` (`is_menu_group`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>menu VALUES("1","General","","1","0","0","0","0","","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("2","Panel Settings","panel_settings.php","0","0","0","1","5","img_2.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("3","Menu Manager","menu_manager.php","0","0","0","1","10","img_3.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("4","Dashboard","home.php","0","0","0","1","0","img_4.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("5","Account Manager","","1","0","0","0","10","","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("6","Pages Manager","","1","0","0","0","5","","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("7","Help","help.php","0","0","0","1","20","img_7.png","1","1","0","1");
INSERT INTO <DB_PREFIX>menu VALUES("8","Static Pages","static_pages_manager.php","0","0","0","6","0","img_8.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("9","Admins","admins.php","0","0","0","5","0","img_9.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("10","DataGrid Pages","datagrid_pages_manager.php","0","0","0","6","10","img_10.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("11","Dynamic Pages","dynamic_pages_manager.php","0","0","0","6","5","img_11.png","1","1","1","0");
INSERT INTO <DB_PREFIX>menu VALUES("12","Admin Tools","","1","0","0","0","15","","1","1","1","2");
INSERT INTO <DB_PREFIX>menu VALUES("13","Timer","timer.php","0","0","0","12","5","img_axumt73fs8.png","1","1","1","2");
INSERT INTO <DB_PREFIX>menu VALUES("14","Users","users.php","0","0","0","5","5","img_u1tpusrkjl.png","1","1","1","3");
INSERT INTO <DB_PREFIX>menu VALUES("15","Modules","modules_manager.php","0","0","0","1","15","img_15.png","1","1","0","0");
INSERT INTO <DB_PREFIX>menu VALUES("16","Backup","backup.php","0","0","0","12","0","module_thumb_1.png","1","1","1","0");


DROP TABLE IF EXISTS <DB_PREFIX>menu_access_rights;
CREATE TABLE `<DB_PREFIX>menu_access_rights` (
  `id` int(10) NOT NULL auto_increment,
  `admin_id` int(10) NOT NULL,
  `menu_id` int(10) NOT NULL,
  `is_accessible` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>menu_access_rights VALUES("1","2","5","0");
INSERT INTO <DB_PREFIX>menu_access_rights VALUES("2","2","6","1");
INSERT INTO <DB_PREFIX>menu_access_rights VALUES("3","2","1","1");


DROP TABLE IF EXISTS <DB_PREFIX>modules;
CREATE TABLE `<DB_PREFIX>modules` (
  `id` smallint(6) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `icon_file` varchar(50) NOT NULL,
  `menu_id` int(10) NOT NULL default '0',
  `parent_menu_id` int(10) NOT NULL default '0',
  `is_installed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>modules VALUES("1","Backup","module_thumb_1.png","16","12","1");


DROP TABLE IF EXISTS <DB_PREFIX>settings;
CREATE TABLE `<DB_PREFIX>settings` (
  `id` tinyint(3) NOT NULL auto_increment,
  `site_name` varchar(125) character set utf8 NOT NULL,
  `site_address` varchar(125) NOT NULL default '',
  `css_style` varchar(10) NOT NULL default '',
  `header_text` varchar(125) character set utf8 NOT NULL,
  `site_language` char(2) NOT NULL default 'en',
  `datagrid_css_style` varchar(10) NOT NULL default 'default',
  `menu_style` enum('left','top') NOT NULL default 'left',
  `smtp_address` varchar(125) NOT NULL default '',
  `smtp_port` char(3) NOT NULL default '25',
  `smtp_username` varchar(30) NOT NULL default '',
  `smtp_password` varchar(20) NOT NULL default '',
  `session_timeout` smallint(6) NOT NULL default '20',
  `passwords_encryption` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>settings VALUES("1","Admin Panel Development","domain.com","blue","Admin Panel","en","blue","left","","25","","","30","0");


DROP TABLE IF EXISTS <DB_PREFIX>static_pages;
CREATE TABLE `<DB_PREFIX>static_pages` (
  `id` int(10) NOT NULL auto_increment,
  `menu_id` int(10) NOT NULL default '0',
  `page_header` varchar(255) NOT NULL,
  `page_text` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO <DB_PREFIX>static_pages VALUES("1","7","Page Header","<P>This is HTML static page <BR>This page was created on: Sep 04, 2017 02:16 PM <BR><BR>PHP AdminPanel (PHP AP) provides you access to the control features of your site as creating static or dynamical pages and allows your easily manage database tables with embedded PHP DataGrid. It includes Creating, Reading, Updating and Deleting (CRUD) records in database tables on your existing site. You can edit menu options 'on fly' and create new menu just in a few clicks. </P>
<P>For&nbsp;a few minutes you get professional looking and fully functional Administration Panel for your new or existing site. ApPHP AdminPanel allows you to create DataGrid pages, even without programming knowledge! It dramatically reduce the development time of your web application. </P>
<P>The PHP AP is an excellent tool for: 
<UL class=normal>
<LI>PHP database-driven web site 
<LI>Adding Back-End for existing site 
<LI>Creating online-based data administration 
<LI>Creating dynamic content management or your own CMS </LI></UL>");


DROP TABLE IF EXISTS <DB_PREFIX>users;
CREATE TABLE `<DB_PREFIX>users` (
  `id` int(10) NOT NULL auto_increment,
  `username` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `last_name` varchar(50) NOT NULL default '',
  `first_name` varchar(50) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `status` enum('seller','buyer') NOT NULL default 'buyer',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO <DB_PREFIX>users VALUES("1","member1","test","Roby","Leston","user@domain.com","buyer");
INSERT INTO <DB_PREFIX>users VALUES("2","member2","test","John","Gorgon","user2@domain.com","buyer");



