<?php
    // Initialize the session.
    session_start();
    
    require_once("../inc/checkAdminPagePermissions.php");
    require_once("../inc/config.inc.php");
    require_once("../inc/settings.inc.php");
	require_once("../inc/functions.inc.php");
	require_once("../inc/backup.class.php");

	ob_start();
	
	$submition_type = isset($_POST['submition_type']) ? $_POST['submition_type'] : "";
	$backup_file 	= isset($_POST['backup_file']) ? $_POST['backup_file'] : "";
	$st 			= isset($_GET['st']) ? $_GET['st'] : "";
	$fname 		    = isset($_GET['fname']) ? $_GET['fname'] : "";
	$msg            = draw_message("normal", "This module allows you to perform a full site backup.", false, "100%", "../");;

    $db=new Database();	
	$objBackup = new Backup($db);
	
	if($submition_type == "1"){		
		// save backup
		if($objBackup->ExecuteBackup($backup_file)){
			$msg = draw_message("success", str_replace("_FILE_NAME_", $backup_file, "Backup _FILE_NAME_ was successfully created."), false, "100%", "../");
		}else{
			$msg = draw_message("error", $objBackup->error, false, "100%", "../");
		}		
	}else if($st == "delete"){
		// delete previouse backup		
		if($objBackup->DeleteBackup($fname)){
			$msg = draw_message("success", str_replace("_FILE_NAME_", $fname, "Backup _FILE_NAME_ was successfully deleted."), false, "100%", "../");
		}else{
			$msg = draw_message("error", $objBackup->error, false, "100%", "../");
		}
	}else if($st == "restore"){
		// restore previouse backup		
		if($objBackup->RestoreBackup($fname)){
			$msg = draw_message("success", str_replace("_FILE_NAME_", $fname, "Backup _FILE_NAME_ was successfully restored."), false, "100%", "../");
		}else{
			$msg = draw_message("error", $objBackup->error, false, "100%", "../");
		}
	}

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
    <title>Site :: Home</title>
    <link href="../styles/<?php echo $SETTINGS['css_style'];?>/style.css" type=text/css rel=stylesheet>
</head>
<body style="padding:10px;padding-top:0px;">
<br />
	<table align="center" width="670px" border="0" cellspacing="0" cellpadding="3" class="main_text">
	<tr valign="middle">
		<td colspan="2">
            <?php
                echo $msg;
            ?>
        </td>
    </tr>    
	<tr valign="top">
		<td width="40%" align="right">
			<form action="backup.php" method="post">
			<input type="hidden" name="submition_type" value="1" />
			<table align="right" width="100%" border="0" cellspacing="0" cellpadding="3" class="main_text">
			<tr><td colspan="2">&nbsp;</td></tr>
			<tr>
				<td align="left" colspan="2"><b>Backup you site: </b></td>		
			</tr>
			<tr><td colspan="2">&nbsp;</td></tr>
			<tr>
				<td align="left" width="1%"><input type="text" name="backup_file" value="<?php echo date("M-d-Y");?>" size="24" maxlength="20" /></td>
				<td align="left"><input class="form_button" type="submit" name="submit" value="BackUp" /></td>
			</tr>
			</table>
			</form>
		</td>
		<td width="60%" align="left">
			<table align="center" width="100%" border="0" cellspacing="0" cellpadding="3" class="main_text">
			<tr><td colspan="6">&nbsp;</td></tr>
			<tr>
				<td align="left" colspan="6"><b>Existing Backups: </b></td>		
			</tr>
			<tr><td colspan="6">&nbsp;</td></tr>
			<?php
				$objBackup->ShowPreviouseBackups("delete,restore");
			?>
		</table>			
		</td>
	</tr>
	</table>
<br />
</body>
</html>

<?php ob_end_flush(); ?>