<?php
###############################################################################
##              -= YOU MAY NOT REMOVE OR CHANGE THIS NOTICE =-                 #
## --------------------------------------------------------------------------- #
##  ApPHP AdminPanel Basic version                                             #
##  Developed by:  ApPhp <info@apphp.com>                                      # 
##  License:       GNU GPL v.2                                                 #
##  Site:          https://www.apphp.com/php-adminpanel/                       #
##  Copyright:     ApPHP AdminPanel (c) 2006-2017. All rights reserved.        #
##                                                                             #
################################################################################

    header("content-type: text/html; charset=utf-8");
    
    // Initialize the session.
    session_start();
    
    require_once("../inc/checkAdminPagePermissions.php");
    require_once("../inc/config.inc.php");
    require_once("../inc/settings.inc.php");
	require_once("../inc/functions.inc.php");

    $db=new Database();	
    $db->open();

    $unique_prefix = "cp_";    /* prevent overlays - must be started with a letter */
                                 
    $mode           = isset($_REQUEST[$unique_prefix.'mode']) ? $_REQUEST[$unique_prefix.'mode'] : "";
    $rid            = isset($_REQUEST[$unique_prefix.'rid']) ? (int)$_REQUEST[$unique_prefix.'rid'] : "";
    $msg            = isset($_GET['msg']) ? $_GET['msg'] : "";
	$page_type      = isset($_REQUEST['page_type']) ? $_REQUEST['page_type'] : "";
    #$mgid           = isset($_GET['mgid']) ? $_GET['mgid'] : "";
    #$moid           = isset($_GET['moid']) ? $_GET['moid'] : "";
    #$act            = isset($_GET['act']) ? $_GET['act'] : "";
    $page_name      = isset($_POST['rtypage_name']) ? $_POST['rtypage_name'] : "";
    $file_type_id   = isset($_POST['riyfile_type_id']) ? $_POST['riyfile_type_id'] : "";
    $file_type      = "1"; // default - static
    $file_path      = "../pages/";
    $css_class      = isset($SETTINGS['datagrid_css_style']) ? $SETTINGS['datagrid_css_style'] : "default";
	$styis_create_file = isset($_POST['styis_create_file']) ? $_POST['styis_create_file'] : "";
	
     
    //--------------------------------------------------------------------------
    // Menu item was deleted   
    //--------------------------------------------------------------------------
    if($mode == "cancel")
	{
		if($page_type == "static"){
			echo "<script type='text/javascript'>document.location.href='static_pages_manager.php';</script>";
			exit;
		}
		
    }
 
#    // Check for deleting non-removable menu groups
#    if($mode == "delete"){
#        $db->query("SELECT * FROM "._DB_PREFIX."menu WHERE id=".intval($rid));
#        if($r__ = $db->fetchAssoc()){
#            $page_name = $r__['page_name'];
#            $file_type = $r__['file_type_id'];            
#            if(intval($r__['is_removable']) == intval("0")){
#                echo "<script>document.location.href='menu_options_manager.php?msg=1&moid=".$moid."&mgid=".$mgid."';</script>";
#                exit;
#            }
#        }
#    }
#    
#    // Hide/Unhide Menu group
#    if($act != ""){
#		if(strtolower(_SITE_MODE) == "demo"){
#			$msg = "2";			
#		}else{			
#			if($act == "Hide"){
#				$hide_value = "1";
#			}else{
#				$hide_value = "0";
#			}
#			$db->query("UPDATE "._DB_PREFIX."menu SET is_hidden =".intval($hide_value)." WHERE id=".intval($moid));			
#		}
#    }
#    
#    $db->query("SELECT * FROM "._DB_PREFIX."menu WHERE id=".intval($mgid));
#    if($r__ = $db->fetchAssoc()){
#        $menu_section_page = $r__['name'];
#    }else $menu_section_page = "";
#    
#    if($page_name == ""){
#        $db->query("SELECT * FROM "._DB_PREFIX."menu WHERE id=".intval($rid));
#        if($r__ = $db->fetchAssoc()){
#            $page_name = $r__['page_name'];
#            $file_type = $r__['file_type_id'];            
#        }        
#    }
    
  
################################################################################
## +---------------------------------------------------------------------------+
## | 1. Creating & Calling:                                                    | 
## +---------------------------------------------------------------------------+
##  *** define a relative (virtual) path to datagrid.class.php file and "pear" 
##  *** directory (relatively to the current file)
##  *** RELATIVE PATH ONLY ***
//
	define ("DATAGRID_DIR", "../modules/datagrid/");  /* Ex.: "datagrid/" */ 
	define ("PEAR_DIR", "../modules/datagrid/pear/"); /* Ex.: "datagrid/pear/" */
  
	require_once(DATAGRID_DIR.'datagrid.class.php');
	require_once(PEAR_DIR.'PEAR.php');
	require_once(PEAR_DIR.'DB.php');
##
##  *** creating variables that we need for database connection

##  *** (example of ODBC connection string)
##  *** $result_conn = $db_conn->connect(DB::parseDSN('odbc://root:12345@test_db'));
##  *** (example of Oracle connection string)
##  *** $result_conn = $db_conn->connect(DB::parseDSN('oci8://root:12345@localhost:1521/mydatabase)); 
##  *** (example of PostgreSQL connection string)
##  *** $result_conn = $db_conn->connect(DB::parseDSN('pgsql://root:12345@localhost/mydatabase)); 
##  === (Examples of connections to other db types see in "docs/pear/" folder)
  
  ob_start();
  $db_conn = DB::factory('mysql');  /* don't forget to change on appropriate db type */
  
  $config = new Config();
  $DB_USER = $config->user;
  $DB_PASS = $config->password;
  $DB_HOST = $config->host;
  $DB_NAME = $config->database;
  
  $result_conn = $db_conn->connect(DB::parseDSN('mysql://'.$DB_USER.':'.$DB_PASS.'@'.$DB_HOST.'/'.$DB_NAME));
  if(DB::isError($result_conn)){ die($result_conn->getDebugInfo()); }  
##  *** put a primary key on the first place 
   $sql = "SELECT
        "._DB_PREFIX."menu.id,
        "._DB_PREFIX."menu.name,
        "._DB_PREFIX."menu.page_name,
        "._DB_PREFIX."menu.is_menu_group,
        "._DB_PREFIX."menu.is_removable,
        "._DB_PREFIX."menu.is_hidden,
        "._DB_PREFIX."menu.icon,
        "._DB_PREFIX."menu.parent_id,
        "._DB_PREFIX."menu.order_index,
        CASE
            WHEN "._DB_PREFIX."menu.is_menu_item = 1 THEN 'Show'
            ELSE \"Don't Show\"
        END as my_is_menu_item,        
        CASE
            WHEN "._DB_PREFIX."menu.is_dashboard_icon = 1 THEN 'Show'
            ELSE \"Don't Show\"
        END as my_is_dashboard_icon,        
        CASE
            WHEN "._DB_PREFIX."menu.is_removable = 1 THEN 'Yes'
            ELSE 'No'
        END as my_removable,        
        CASE
            WHEN "._DB_PREFIX."menu.is_hidden = 1 THEN 'Unhide'
            ELSE 'Hide'
        END as hidden_link,
        CASE
            WHEN "._DB_PREFIX."menu.is_menu_group = 1 THEN ''
            ELSE page_name
        END as my_page_name,
        'Menu Options' as menu_options_link,
        CASE
            WHEN "._DB_PREFIX."menu.file_type_id = 1 THEN CONCAT('<a class=\"".$css_class."_dg_a\" href=\"static_pages_manager.php?sp_mode=edit&sp_rid=', "._DB_PREFIX."static_pages.id, '\">[Edit Content]</a>')
            WHEN "._DB_PREFIX."menu.file_type_id = 2 THEN CONCAT('<a class=\"".$css_class."_dg_a\" href=\"dynamic_pages_editor.php?dpid=', "._DB_PREFIX."dynamic_pages.id, '\">', '[Edit Content]</a>')
            WHEN "._DB_PREFIX."menu.file_type_id = 3 THEN CONCAT('<a class=\"".$css_class."_dg_a\" href=\"datagrid_pages_editor.php?dpid=', "._DB_PREFIX."datagrid_pages.id, '\">', '[Edit Content]</a>')
            ELSE 'Not Editable'
        END page_edit_link,
        "._DB_PREFIX."menu.file_type_id,
        "._DB_PREFIX."file_types.name as file_type_name
    FROM "._DB_PREFIX."menu
        LEFT OUTER JOIN "._DB_PREFIX."file_types ON "._DB_PREFIX."menu.file_type_id = "._DB_PREFIX."file_types.id
        LEFT OUTER JOIN "._DB_PREFIX."static_pages ON "._DB_PREFIX."menu.id = "._DB_PREFIX."static_pages.menu_id
        LEFT OUTER JOIN "._DB_PREFIX."dynamic_pages ON "._DB_PREFIX."menu.id = "._DB_PREFIX."dynamic_pages.menu_id
        LEFT OUTER JOIN "._DB_PREFIX."datagrid_pages ON "._DB_PREFIX."menu.id = "._DB_PREFIX."datagrid_pages.menu_id
    WHERE
        "._DB_PREFIX."menu.is_menu_group = 0 ";
	
	if($page_type == "static"){
		$sql .= " AND "._DB_PREFIX."menu.file_type_id = 1 ";
	}
	//"._DB_PREFIX."menu.parent_id = ".(int)$mgid."	
    
##  *** set needed options and create a new class instance 
  $debug_mode = false;        /* display SQL statements while processing */    
  $messaging = true;          /* display system messages on a screen */ 
  $dgrid = new DataGrid($debug_mode, $messaging, $unique_prefix, DATAGRID_DIR);
  if(strtolower(_SITE_MODE) == "demo") $dgrid->isDemo = true;
  //$dgrid->navigationBar = "<a class='".$css_class."_dg_a' href='menu_manager.php'>&laquo; Back to Menu Manager</a></center>";  

##  *** set data source with needed options
  $default_order_field = "order_index";
  $default_order_type = "ASC";
  $dgrid->dataSource($db_conn, $sql, $default_order_field, $default_order_type);
  
##
##
## +---------------------------------------------------------------------------+
## | 2. General Settings:                                                      | 
## +---------------------------------------------------------------------------+
##  *** set encoding and collation (default: utf8/utf8_unicode_ci)
/// $dg_encoding = "utf8";
/// $dg_collation = "utf8_unicode_ci";
/// $dgrid->setEncoding($dg_encoding, $dg_collation);
##  *** set interface language (default - English)
##  *** (en) - English     (de) - German     (se) - Swedish   (hr) - Bosnian/Croatian
##  *** (hu) - Hungarian   (es) - Espanol    (ca) - Catala    (fr) - Francais
##  *** (nl) - Netherlands/"Vlaams"(Flemish) (it) - Italiano  (pl) - Polish
##  *** (ch) - Chinese     (sr) - Serbian    (bg) - Bulgarian (pb) - Brazilian Portuguese
##  *** (ar) - Arabic      (tr) - Turkish    (cz) - Czech
 $dg_language = $SETTINGS['site_language'];  
 $dgrid->setInterfaceLang($dg_language);
##  *** set direction: "ltr" or "rtr" (default - "ltr")
/// $direction = "ltr";
/// $dgrid->setDirection($direction);
##  *** set layouts: "0" - tabular(horizontal) - default, "1" - columnar(vertical), "2" - customized 
/// $layouts = array("view"=>"0", "edit"=>"1", "details"=>"1", "filter"=>"1"); 
/// $dgrid->setLayouts($layouts);
/// $details_template = "<table><tr><td>{field_name_1}</td><td>{field_name_2}</td></tr>...</table>";
/// $dgrid->setTemplates("","",$details_template);
##  *** set modes for operations ("type" => "link|button|image") 
##  *** "byFieldValue"=>"fieldName" - make the field to be a link to edit mode page
 $modes = array(
     "add"	=>array("view"=>true, "edit"=>false, "type"=>"link"),
     "edit"	=>array("view"=>true, "edit"=>true,  "type"=>"link", "byFieldValue"=>""),
     "cancel"   =>array("view"=>true, "edit"=>true,  "type"=>"link"),
     "details"  =>array("view"=>false, "edit"=>false, "type"=>"link"),
     "delete"   =>array("view"=>false, "edit"=>false,  "type"=>"image")
 );
 $dgrid->setModes($modes);
##  *** allow scrolling on datagrid
/// $scrolling_option = false;
/// $dgrid->allowScrollingSettings($scrolling_option);  
##  *** set scrolling settings (optional)
/// $scrolling_width = "90%";
/// $scrolling_height = "100%";
/// $dgrid->setScrollingSettings($scrolling_width, $scrolling_height);
##  *** allow mulirow operations
  $multirow_option = false;
  $dgrid->allowMultirowOperations($multirow_option);
  $multirow_operations = array(
     "delete"  => array("view"=>true),
     "details" => array("view"=>false),
//     "my_operation_name" => array("view"=>true, "flag_name"=>"my_flag_name", "flag_value"=>"my_flag_value", "tooltip"=>"Do something with selected", "image"=>"image.gif")
 );
 $dgrid->setMultirowOperations($multirow_operations);  
##  *** set CSS class for datagrid
##  *** "default" or "blue" or "gray" or "green" or "pink" or your own css file 
 $dgrid->setCssClass($css_class);
##  *** set variables that used to get access to the page (like: my_page.php?act=34&id=56 etc.) 
 $http_get_vars = array("page_type");
 $dgrid->setHttpGetVars($http_get_vars);
##  *** set other datagrid/s unique prefixes (if you use few datagrids on one page)
##  *** format (in which mode to allow processing of another datagrids)
##  *** array("unique_prefix"=>array("view"=>true|false, "edit"=>true|false, "details"=>true|false));
/// $anotherDatagrids = array("abcd_"=>array("view"=>true, "edit"=>true, "details"=>true));
/// $dgrid->setAnotherDatagrids($anotherDatagrids);  
##  *** set DataGrid caption
 $dg_caption = "Create ".$page_type." page";
 $dgrid->setCaption($dg_caption);
##
##
## +---------------------------------------------------------------------------+
## | 3. Printing & Exporting Settings:                                         | 
## +---------------------------------------------------------------------------+
##  *** set printing option: true(default) or false 
 $printing_option = true;
 $dgrid->allowPrinting($printing_option);
##  *** set exporting option: true(default) or false and relative (virtual) path
##  *** to export directory (relatively to datagrid.class.php file).
##  *** Ex.: "" - if we use current datagrid folder
 $exporting_option = false;
 $exporting_directory = "export/";               
 $dgrid->allowExporting($exporting_option, $exporting_directory);
##
##
## +---------------------------------------------------------------------------+
## | 4. Sorting & Paging Settings:                                             | 
## +---------------------------------------------------------------------------+
##  *** set sorting option: true(default) or false 
/// $sorting_option = true;
/// $dgrid->allowSorting($sorting_option);               
##  *** set paging option: true(default) or false 
/// $paging_option = true;
/// $rows_numeration = false;
/// $numeration_sign = "N #";
/// $dgrid->allowPaging($paging_option, $rows_numeration, $numeration_sign);
##  *** set paging settings
 #$bottom_paging = array("results"=>true, "results_align"=>"left", "pages"=>true, "pages_align"=>"center", "page_size"=>true, "page_size_align"=>"right");
 #$top_paging = array();
 #$pages_array = array("10"=>"10", "25"=>"25", "50"=>"50", "100"=>"100", "250"=>"250", "500"=>"500", "1000"=>"1000");
 #$default_page_size = 10;
 #$paging_arrows = array("first"=>"|&lt;&lt;", "previous"=>"&lt;&lt;", "next"=>"&gt;&gt;", "last"=>"&gt;&gt;|");
 #$dgrid->setPagingSettings($bottom_paging, $top_paging, $pages_array, $default_page_size, $paging_arrows);
##
##
## +---------------------------------------------------------------------------+
## | 5. Filter Settings:                                                       | 
## +---------------------------------------------------------------------------+
##  *** set filtering option: true or false(default)
# $filtering_option = true;
# $show_search_type = true;
# $dgrid->allowFiltering($filtering_option, $show_search_type);
###  *** set aditional filtering settings
# //$fill_from_array = array("0"=>"No", "1"=>"Yes");  /* as "value"=>"option" */
# $filtering_fields = array(
#     "Last Name"=>array("table"=>"a", "field"=>"last_name", "source"=>"self", "show_operator"=>false, "default_operator"=>"like%", "order"=>"ASC", "type"=>"textbox", "case_sensitive"=>false, "comparison_type"=>"string"),
#///     "Caption_2"=>array("table"=>"tableName_2", "field"=>"fieldName_2", "source"=>"self"|$fill_from_array, "show_operator"=>false|true, "default_operator"=>"=|<|>|like|%like|like%|not like", "order"=>"ASC|DESC (optional)", "type"=>"textbox|dropdownlist", "case_sensitive"=>false|true, "comparison_type"=>"string|numeric|binary"),
#///     "Caption_3"=>array("table"=>"tableName_3", "field"=>"fieldName_3", "source"=>"self"|$fill_from_array, "show_operator"=>false|true, "default_operator"=>"=|<|>|like|%like|like%|not like", "order"=>"ASC|DESC (optional)", "type"=>"textbox|dropdownlist", "case_sensitive"=>false|true, "comparison_type"=>"string|numeric|binary")
# );
# $dgrid->setFieldsFiltering($filtering_fields);
##
## 
## +---------------------------------------------------------------------------+
## | 6. View Mode Settings:                                                    | 
## +---------------------------------------------------------------------------+
##  *** set view mode table properties
 $vm_table_properties = array("width"=>"85%");
 $dgrid->setViewModeTableProperties($vm_table_properties);  
##  *** set columns in view mode
##  *** Ex.: "on_js_event"=>"onclick='alert(\"Yes!!!\");'"
##  ***      "barchart" : number format in SELECT SQL must be equal with number format in max_value
 $vm_colimns = array(
    "icon"              =>array("header"=>"Icon", "type"=>"image",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>"false", "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower|camel", "summarize"=>"false", "sort_type"=>"string|numeric", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "target_path"=>"../images/icons/", "default"=>"", "image_width"=>"25px", "image_height"=>"25px", "magnify"=>"true", "magnify_type"=>"magnifier"),
    "name"              =>array("header"=>"Menu Option Name", "type"=>"label",      "align"=>"left", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
    "file_type_name"    =>array("header"=>"File Type", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),    
    "my_is_menu_item"   =>array("header"=>" Menu ", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
    "my_is_dashboard_icon" =>array("header"=>"Dashboard", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),    
    "order_index"       =>array("header"=>"Order", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
    "my_removable"      =>array("header"=>"Is Removable?", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
    "page_edit_link"    =>array("header"=>" ", "type"=>"label",      "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),     
    //"hidden_link"       =>array("header"=>" ", "type"=>"link",       "align"=>"center", "width"=>"", "wrap"=>"nowrap", "text_length"=>"-1", "tooltip"=>false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "field_key"=>"hidden_link", "field_key_1"=>"id", "field_data"=>"hidden_link", "rel"=>"", "title"=>"Hide/Unhide menu option", "target"=>"", "href"=>"menu_options_manager.php?act={0}&mgid=".$mgid."&moid={1}"),
 
///     "FieldName_1"=>array("header"=>"Name_A", "type"=>"label",      "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_2"=>array("header"=>"Name_B", "type"=>"image",      "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "target_path"=>"uploads/", "default"=>"default_image.ext", "image_width"=>"50px", "image_height"=>"30px"),
///     "FieldName_3"=>array("header"=>"Name_C", "type"=>"linktoview", "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_3"=>array("header"=>"Name_C", "type"=>"linktoedit", "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_4"=>array("header"=>"Name_D", "type"=>"link",       "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "field_key"=>"field_name_0"|"field_key_1"=>"field_name_1"|..., "field_data"=>"field_name_2", "rel"=>"", "title"=>"", "target"=>"_new", "href"=>"{0}"),
///     "FieldName_5"=>array("header"=>"Name_E", "type"=>"link",       "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "field_key"=>"field_name_0"|"field_key_1"=>"field_name_1"|..., "field_data"=>"field_name_2", "rel"=>"", "title"=>"", "target"=>"_new", "href"=>"mailto:{0}"),
///     "FieldName_6"=>array("header"=>"Name_F", "type"=>"link",       "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "field_key"=>"field_name_0"|"field_key_1"=>"field_name_1"|..., "field_data"=>"field_name_2", "rel"=>"", "title"=>"", "target"=>"_new", "href"=>"http://mydomain.com?act={0}&act={1}&code=ABC"),
///     "FieldName_7"=>array("header"=>"Name_G", "type"=>"password",   "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_8"=>array("header"=>"Name_H", "type"=>"barchart",   "align"=>"left", "width"=>"X%|Xpx", "wrap"=>"wrap|nowrap", "text_length"=>"-1", "tooltip"=>true|false, "tooltip_type"=>"floating|simple", "case"=>"normal|upper|lower", "summarize"=>"true|false", "sort_by"=>"", "visible"=>"true", "on_js_event"=>"", "field"=>"field_name", "maximum_value"=>"value")
 );
 $dgrid->setColumnsInViewMode($vm_colimns);
##  *** set auto-genereted columns in view mode
//  $auto_column_in_view_mode = false;
//  $dgrid->setAutoColumnsInViewMode($auto_column_in_view_mode);
##
##
## +---------------------------------------------------------------------------+
## | 7. Add/Edit/Details Mode Settings:                                        | 
## +---------------------------------------------------------------------------+
##  *** set add/edit mode table properties
 $em_table_properties = array("width"=>"60%");
 $dgrid->setEditModeTableProperties($em_table_properties);
##  *** set details mode table properties
/// $dm_table_properties = array("width"=>"70%");
/// $dgrid->setDetailsModeTableProperties($dm_table_properties);
##  ***  set settings for add/edit/details modes
  $table_name  = _DB_PREFIX."menu";
  $primary_key = "id";
  $condition   = "";//"table_name.field = ".$_REQUEST['abc_rid'];
  $dgrid->setTableEdit($table_name, $primary_key, $condition);
##  *** set columns in edit mode
##  *** first letter:  r - required, s - simple (not required)
##  *** second letter: t - text(including datetime), n - numeric, a - alphanumeric,
##                     e - email, f - float, y - any, l - login name, z - zipcode,
##                     p - password, i - integer, v - verified, c - checkbox, u - URL
##  *** third letter (optional): 
##          for numbers: s - signed, u - unsigned, p - positive, n - negative
##          for strings: u - upper,  l - lower,    n - normal,   y - any
##  *** Ex.: "on_js_event"=>"onclick='alert(\"Yes!!!\");'"
##  *** Ex.: type = textbox|textarea|label|date(yyyy-mm-dd)|datedmy(dd-mm-yyyy)|datetime(yyyy-mm-dd hh:mm:ss)|datetimedmy(dd-mm-yyyy hh:mm:ss)|time(hh:mm:ss)|image|password|enum|print|checkbox
##  *** make sure your WYSIWYG dir has 777 permissions
 $fill_from_array_hidden    = array("0"=>"No", "1"=>"Yes"); /* as "value"=>"option" */
 $fill_from_array_removable = array("0"=>"No", "1"=>"Yes"); 
 $fill_from_array_dashboard = array("0"=>"No", "1"=>"Yes"); 
 $fill_from_array_menu      = array("0"=>"No", "1"=>"Yes");
 
 $em_columns = array(
 
    "parent_id"      =>array("header"=>"Menu Group", "type"=>"foreign_key", "req_type"=>"ri", "width"=>"210px", "title"=>"", "readonly"=>(($mode == "edit") ? "true" : "false"), "default"=>"", "unique"=>"false", "unique_condition"=>"", "visible"=>"true"),
    "name"           =>array("header"=>"Menu Option Name", "type"=>"textbox",   "req_type"=>"ry", "width"=>"210px", "title"=>"Menu Group Name", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
    "page_name"      =>array("header"=>"Page Name", "type"=>"textbox",   "req_type"=>"rt", "width"=>"210px", "title"=>"Page Name", "readonly"=>(($file_type > "0") ? (($mode == "edit") ? "true" : "false") : "true"), "maxlength"=>"-1", "default"=>"", "unique"=>true, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "post_addition"=>(($file_type > "0" && ($file_type == "2" || $file_type == "3")) ? "<br />PHP pages will be placed in directory <b>pages/</b>" : "<br />Use .php exention for PHP Simple and PHP Datagrid pages")),
    "order_index"    =>array("header"=>"Order Index", "type"=>"textbox",   "req_type"=>"ri", "width"=>"50px", "title"=>"Order Index", "readonly"=>false, "maxlength"=>"3", "default"=>"0", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
    "is_removable"   => array("header"=>"Is Removable?",  "type"=>"enum",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"0", "unique"=>false, "unique_condition"=>"", "visible"=>(($file_type > "0") ? "true" : "false"), "on_js_event"=>"", "source"=>$fill_from_array_removable, "view_type"=>"dropdownlist", "radiobuttons_alignment"=>"horizontal|vertical", "multiple"=>false, "multiple_size"=>"4"),
    "is_hidden"      =>array("header"=>"Is Hidden?",  "type"=>"enum",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"0", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "source"=>$fill_from_array_hidden, "view_type"=>"dropdownlist", "radiobuttons_alignment"=>"horizontal|vertical", "multiple"=>false, "multiple_size"=>"4"),
    "is_menu_item"      =>array("header"=>"Show In Menu?",  "type"=>"enum",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"1", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "source"=>$fill_from_array_menu, "view_type"=>"dropdownlist", "radiobuttons_alignment"=>"horizontal|vertical", "multiple"=>false, "multiple_size"=>"4"),
    "is_dashboard_icon" =>array("header"=>"Show In Dashboard?",  "type"=>"enum",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"1", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "source"=>$fill_from_array_dashboard, "view_type"=>"dropdownlist", "radiobuttons_alignment"=>"horizontal|vertical", "multiple"=>false, "multiple_size"=>"4"),
    "icon"           =>array("header"=>"Icon", "type"=>"image",     "req_type"=>"st", "width"=>"220px", "title"=>"", "readonly"=>"false", "maxlength"=>"-1", "default"=>"", "unique"=>"false", "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "target_path"=>"../images/icons/", "max_file_size"=>"100K", "image_width"=>"96px", "image_height"=>"96px", "magnify"=>"false", "file_name"=>"img_".((isset($_GET['cp_mode']) && ($_GET['cp_mode'] == "add")) ? $dgrid->GetRandomString("10") : $dgrid->GetCurrentId()), "host"=>"local", "magnify_type"=>"lightbox"),

    "is_menu_group"  =>array("header"=>"",       "type"=>"hidden",    "req_type"=>"st", "default"=>"0", "unique"=>false),
    "file_type_id"   =>array("header"=>"",       "type"=>"hidden",    "req_type"=>"st", "default"=>"1", "unique"=>false),
    "is_create_file" =>array("header"=>"",       "type"=>"hidden",    "req_type"=>"st", "default"=>"0", "unique"=>false),
    
    //"is_create_file" =>array("header"=>"Create File?", "type"=>"checkbox",  "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"1", "unique"=>false, "unique_condition"=>"", "visible"=>(($mode == "add") ? "true" : "false"), "on_js_event"=>"", "true_value"=>1, "false_value"=>0, "post_addition"=>"(for PHP Simple and PHP DataGrid pages)"),
	//"parent_id"      =>array("header"=>"",       "type"=>"hidden",    "req_type"=>"st", "default"=>intval($mgid), "unique"=>false),
    //"file_type_id"   => array("header"=>"Page Type", "type"=>"foreign_key", "req_type"=>"ri", "default"=>"1", "width"=>"210px", "title"=>"", "readonly"=>(($mode == "edit") ? "true" : "false"), "default"=>"", "unique"=>"false", "unique_condition"=>"", "visible"=>"true"),

///     "FieldName_1"  =>array("header"=>"Name_A", "type"=>"textbox",   "req_type"=>"rt", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_2"  =>array("header"=>"Name_B", "type"=>"textarea",  "req_type"=>"rt", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "edit_type"=>"simple|wysiwyg", "resizable"=>"false", "rows"=>"7", "cols"=>"50"),
///     "FieldName_3"  =>array("header"=>"Name_C", "type"=>"label",     "req_type"=>"rt", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_4"  =>array("header"=>"Name_D", "type"=>"date",      "req_type"=>"rt", "width"=>"187px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "calendar_type"=>"popup|floating"),
///     "FieldName_5"  =>array("header"=>"Name_E", "type"=>"datetime",  "req_type"=>"st", "width"=>"187px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "calendar_type"=>"popup|floating"),
///     "FieldName_6"  =>array("header"=>"Name_F", "type"=>"time",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_7"  =>array("header"=>"Name_G", "type"=>"image",     "req_type"=>"st", "width"=>"220px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "target_path"=>"uploads/", "max_file_size"=>"100000|100K|10M|1G", "image_width"=>"Xpx", "image_height"=>"Ypx", "file_name"=>"Image_Name", "host"=>"local|remote"),
///     "FieldName_8"  =>array("header"=>"Name_H", "type"=>"password",  "req_type"=>"rp", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_9"  =>array("header"=>"Name_I", "type"=>"enum",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "source"=>"self"|$fill_from_array, "view_type"=>"dropdownlist(default)|radiobutton", "radiobuttons_alignment"=>"horizontal|vertical", "multiple"=>false, "multiple_size"=>"4"),
///     "FieldName_10" =>array("header"=>"Name_J", "type"=>"print",     "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>""),
///     "FieldName_11" =>array("header"=>"Name_K", "type"=>"checkbox",  "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "true_value"=>1, "false_value"=>0),
///     "FieldName_12" =>array("header"=>"Name_L", "type"=>"file",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "target_path"=>"uploads/", "max_file_size"=>"100000|100K|10M|1G", "file_name"=>"File_Name", "host"=>"local|remote"),
///     "FieldName_13" =>array("header"=>"Name_M", "type"=>"link",      "req_type"=>"st", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "unique"=>false, "unique_condition"=>"", "visible"=>"true", "on_js_event"=>"", "field_key"=>"field_name_0"|"field_key_1"=>"field_name_1"|..., "field_data"=>"field_name_2", "target"=>"_new", "href"=>"http://mydomain.com?act={0}&act={1}&code=ABC"),
///     "FieldName_14" =>array("header"=>"",       "type"=>"hidden",    "req_type"=>"st", "default"=>"default_value", "visible"=>"true", "unique"=>false|true),
///     "validator"    =>array("header"=>"Name_N", "type"=>"validator", "req_type"=>"rv", "width"=>"210px", "title"=>"", "readonly"=>false, "maxlength"=>"-1", "default"=>"", "visible"=>"true", "on_js_event"=>"", "for_field"=>"", "validation_type"=>"password|email"),
///     "delimiter"    =>array("inner_html"=>"<br />")
 );
 
 $dgrid->setColumnsInEditMode($em_columns);
##  *** set auto-genereted columns in edit mode
//  $auto_column_in_edit_mode = false;
//  $dgrid->setAutoColumnsInEditMode($auto_column_in_edit_mode);
##  *** set foreign keys for add/edit/details modes (if there are linked tables)
##  *** Ex.: "condition"=>"TableName_1.FieldName > 'a' AND TableName_1.FieldName < 'c'"
##  *** Ex.: "on_js_event"=>"onclick='alert(\"Yes!!!\");'"
 $foreign_keys = array(
    "parent_id"    => array("table"=>_DB_PREFIX."menu", "field_key"=>"id", "field_name"=>"name", "view_type"=>"dropdownlist", "radiobuttons_alignment"=>"horizontal|vertical", "condition"=>"is_menu_group = 1", "order_by_field"=>"", "order_type"=>"ASC", "on_js_event"=>""),
///     "ForeignKey_1"=>array("table"=>"TableName_1", "field_key"=>"FieldKey_1", "field_name"=>"FieldName_1", "view_type"=>"dropdownlist(default)|radiobutton|textbox", "radiobuttons_alignment"=>"horizontal|vertical", "condition"=>"", "order_by_field"=>"My_Field_Name", "order_type"=>"ASC|DESC", "on_js_event"=>""),
///     "ForeignKey_2"=>array("table"=>"TableName_2", "field_key"=>"FieldKey_2", "field_name"=>"FieldName_2", "view_type"=>"dropdownlist(default)|radiobutton|textbox", "radiobuttons_alignment"=>"horizontal|vertical", "condition"=>"", "order_by_field"=>"My_Field_Name", "order_type"=>"ASC|DESC", "on_js_event"=>"")
 ); 


 $dgrid->setForeignKeysEdit($foreign_keys);
##

##
################################################################################   


?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3c.org/TR/1999/REC-html401-19991224/loose.dtd">
<html>
<head>
    <title><?php echo $SETTINGS['site_name']; ?> :: Admin Panel</title>
    <meta http-equiv='Content-Type' content='text/html;charset=utf-8' />
    <link href="../styles/<?php echo $SETTINGS['css_style'];?>/style.css" type=text/css rel=stylesheet>
</head>

<!-- BEGIN MAIN CONTENT ARE -->
<body style="background: #ffffff;">
<br />
<?php

	## +---------------------------------------------------------------------------+
	## | 8. Bind the DataGrid:                                                     | 
	## +---------------------------------------------------------------------------+
	##  *** bind the DataGrid and draw it on the screen
	ob_start();    
	if($msg == "1"){
		draw_message("error", "This menu option can not be removed, only hidden! <br>To remove it, please turn removable flag 'ON' before.", true, "85%", "../");
		echo "<br/>";
	}else if($msg == "2"){
		draw_message("error", "This operation is blocked in demo version.", true, "85%", "../");
		echo "<br />";	
	}
	
	$add_msg = draw_message("success", "The adding operation was successfully completed! <br>To be sure that new changes will take effect, please <a href='javascript: top.location.href=top.location.href;'>refresh the site</a> or wait few seconds.", false, "85%", "../");
	$update_msg = draw_message("success", "The updating operation was successfully completed! <br>To be sure that new changes will take effect, please <a href='javascript: top.location.href=top.location.href;'>refresh the site</a> or wait few seconds.", false, "85%", "../");
	$delete_msg = draw_message("success", "The deleting operation was successfully completed! <br>To be sure that new changes will take effect, please <a href='javascript: top.location.href=top.location.href;'>refresh the site</a> or wait few seconds.", false, "85%", "../");
	
	$dgrid->SetDgMessages($add_msg, $update_msg, $delete_msg); 
    if($mode == "update" && $dgrid->IsOperationCompleted())
	{
		$dgrid->bind(false);
	}else{
		$dgrid->bind();
	}
	ob_end_flush();
  

    //--------------------------------------------------------------------------
    // Menu item was deleted   
    //--------------------------------------------------------------------------
	
    if($mode == "delete" && $dgrid->IsOperationCompleted() && $rid != "")
	{
		// delete if static page    
        if($file_type == "1"){
			// do nothing
        }

#        // delete PHP simple page        
#        if($file_type == "2"){        
#            // delete from table
#            $sql = "DELETE FROM "._DB_PREFIX."dynamic_pages WHERE menu_id = ".(int)$rid;
#            $db->query($sql);
#            // delete file
#            @chdir($file_path);
#            @unlink($page_name);            
#        }else
#        // delete PHP DataGrid page        
#        if($file_type == "3"){
#            // delete from table
#            $sql = "DELETE FROM "._DB_PREFIX."datagrid_pages WHERE menu_id = ".(int)$rid;
#            $db->query($sql);
#            // delete file
#            @chdir($file_path);
#            @unlink($page_name);            
#        }
		#if(strtolower(_SITE_MODE) != "demo"){		
		#	if($SETTINGS['menu_style'] == "left"){
		#		echo "<script type='text/javascript'> setTimeout('top[1].location.href=top[1].location.href', 500); </script>";
		#	}
		#}
    }


    //--------------------------------------------------------------------------
    // Menu item was created
    //--------------------------------------------------------------------------
    if($mode == "update" && $rid == "-1" && $dgrid->IsOperationCompleted())
	{
        // create static page
        if($page_type == "static"){
            $page_text = "This is HTML static page <br/>";
            $page_text .= "This page was created on: ".date("M d, Y h:i A")." <br/>";
            
            $sql = "INSERT INTO "._DB_PREFIX."static_pages (id, menu_id, page_header, page_text)
                    VALUES (NULL, ".(int)$dgrid->GetCurrentId().", 'Page Header', '".$page_text."') ";
            $db->query($sql);
        }
        

		if(strtolower(_SITE_MODE) != "demo"){		
			if($SETTINGS['menu_style'] == "left"){
				echo "<script type='text/javascript'>
					setTimeout('top[1].location.href=top[1].location.href', 500);";
				if($page_type == "static"){
					echo " setTimeout('document.location.href=\"static_pages_manager.php\"', 800); ";
				}					
				echo "</script>";
			}
		}

    }
 

?>
<br />
</body>
</html>