<?php
    header("content-type: text/html; charset=utf-8");

    // Initialize the session.
    session_start();
    
    require_once("../inc/checkAdminPagePermissions.php");
    require_once("../inc/config.inc.php");
    require_once("../inc/database.inc.php");
    require_once("../inc/settings.inc.php");
	require_once("../inc/functions.inc.php");

    $dgpid          = isset($_GET['dgpid']) ? (int)$_GET['dgpid'] : "0";
    $act            = isset($_POST['act']) ? $_POST['act'] : "";
    $file_name      = isset($_POST['file_name']) ? $_POST['file_name'] : "";
	
	$selViewModeTable = isset($_POST['selViewModeTable']) ? $_POST['selViewModeTable'] : "";
    $txtUniquePrefix  = isset($_POST['txtUniquePrefix']) ? $_POST['txtUniquePrefix'] : "";
	$selCssClass      = isset($_POST['selCssClass']) ? $_POST['selCssClass'] : "";
	$selPrinting 	  = isset($_POST['selPrinting']) ? $_POST['selPrinting'] : "";
	$selExporting     = isset($_POST['selExporting']) ? $_POST['selExporting'] : "";
	$selExportAll     = isset($_POST['selExportAll']) ? $_POST['selExportAll'] : "";
	$selEditModeTable = isset($_POST['selEditModeTable']) ? $_POST['selEditModeTable'] : "";
	
    $page_content   = "";
    $page_name      = "";
    $msg            = "";
	$created		= false;

    $db=new Database();	
    $db->open();
	$config = new Config();
    
    if($act == "submit"){
		if(strtolower(_SITE_MODE) == "demo"){
			$msg = draw_message("error", "This operation is blocked in demo version.", false, "770px", "../");					
		}else{			
			// check fields
			if($selViewModeTable == ""){
				$msg = draw_message("error", "View Mode table cannot be empty! Please select.", false, "770px", "../");
			}else if($selEditModeTable == ""){
				$msg = draw_message("error", "Edit Mode table cannot be empty! Please select.", false, "770px", "../");
			}			
			
			if($msg == ""){            
				// write data to the file 
				@chmod("../pages/".$file_name, 0755);
				$fh = fopen("../pages/".$file_name, 'w');
				if(!$fh){
					$msg = draw_message("error", "Can not open file: ".$file_name, false, "770px", "../");
				}else{
					$file_content = file_get_contents("templates/php_datagrid_file.tpl");
					
					## +---------------------------------------------------------------------------+
					## | 1. Creating & Calling:                                                    |
					## +---------------------------------------------------------------------------+
						// define datagrid path
						$file_content = str_replace("<DATAGRID_DIR>", "../modules/datagrid/", $file_content);				
						
						// set database connection parameters
						$file_content = str_replace("<DB_USER>", $config->user, $file_content);
						$file_content = str_replace("<DB_PASS>", $config->password, $file_content);
						$file_content = str_replace("<DB_HOST>", $config->host, $file_content);
						$file_content = str_replace("<DB_NAME>", $config->database, $file_content);
						
						// set View Mode SQL SELECT parameters
						$file_content = str_replace("<VIEW_MODE_TABLE>", $selViewModeTable, $file_content);
						
						$arrViewModeFields = array();
						$listViewModeFields = "*";
				
						$sql = "SHOW COLUMNS FROM ".$selViewModeTable;
						$db->query($sql);
						while ($row = $db->fetchArray()){
							$arrViewModeFields[] = $row['Field'];
						}
						if(count($arrViewModeFields) > 0){
							$listViewModeFields = implode(", ", $arrViewModeFields);
						}
						$file_content = str_replace("<VIEW_MODE_FILEDS_LIST>", $listViewModeFields, $file_content);
						$file_content = str_replace("<UNIQUE_PREFIX>", $txtUniquePrefix, $file_content);
						
	
					## +---------------------------------------------------------------------------+
					## | 2. General Settings:                                                      |
					## +---------------------------------------------------------------------------+
						$file_content = str_replace("<CSS_CLASS>", $selCssClass, $file_content);
						
					## +---------------------------------------------------------------------------+
					## | 3. Printing & Exporting Settings:                                         | 
					## +---------------------------------------------------------------------------+
						$file_content = str_replace("<PRINTING_OPTION>", $selPrinting, $file_content);
						$file_content = str_replace("<EXPORTING_OPTION>", $selExporting, $file_content);
						$file_content = str_replace("<EXPORT_ALL>", $selExportAll, $file_content);
					
					## +---------------------------------------------------------------------------+
					## | 7. Add/Edit/Details Mode Settings:                                        |
					## +---------------------------------------------------------------------------+
						$file_content = str_replace("<EDIT_MODE_TABLE>", $selEditModeTable, $file_content);
	
						$sql = "SHOW COLUMNS FROM ".$selEditModeTable;
						$db->query($sql);
						$editModePrimatyKey = "id";
						if($row = $db->fetchArray()){
							$editModePrimatyKey = $row[0];
						}
						$file_content = str_replace("<EDIT_MODE_PRIMARY_KEY>", $editModePrimatyKey, $file_content);
					
					## +---------------------------------------------------------------------------+								
						// remove all unnecessary comments				
						$file_content = str_replace("//*//", "", $file_content);
						$file_content = str_replace("<DATE_CREATED>", date("M d, Y h:i A"), $file_content);
						$file_content = str_replace("<FILE_NAME>", $page_name, $file_content);	
					
					fwrite($fh, $file_content);
					fclose($fh);
					$msg = draw_message("success", "The DataGrid page was susseccfully created!", false, "770px", "../");
					$created = true;
				}
				@chmod("../pages/".$file_name, 0644);
			}
		}
    }

    $sql = "SELECT
            "._DB_PREFIX."menu.name,
            "._DB_PREFIX."menu.page_name
        FROM "._DB_PREFIX."datagrid_pages
            INNER JOIN "._DB_PREFIX."menu ON "._DB_PREFIX."datagrid_pages.menu_id = "._DB_PREFIX."menu.id
        WHERE "._DB_PREFIX."datagrid_pages.id = ".$dgpid;
    $db->query($sql);
    //echo $db->error();
    if($row = $db->fetchArray()){
        $file_name = $row['page_name'];
        $page_name = $row['name'];
    }

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
    <title>Site :: Home</title>
    <link href="../styles/<?php echo $SETTINGS['css_style'];?>/style.css" type=text/css rel=stylesheet>
    <script type="text/javascript">
        function btnCancel_OnClick(){
            document.location.href = "datagrid_pages_manager.php";
        }

        function btnView_OnClick(){
            document.location.href = "<?php echo "../pages/".$file_name; ?>";
        }
        
        function btnSubmit_OnClick(){						
            var frm = document.getElementById("frmEditPage");
			var unique_prefix = frm.txtUniquePrefix.value;
			
			if(isDigit(unique_prefix.substr(0, 1))){
				alert("Unique prefix cannot start from digit! Please re-enter.");
				return false;
			}
            frm.submit();
        }
		
		function selViewModeTable_OnChange(){
			var selVM = document.getElementById("selViewModeTable");
			var selEM = document.getElementById("selEditModeTable");
			selEM.selectedIndex = selVM.selectedIndex;			
		}

		function isDigit(c){
		   return ((c >= "0") && (c <= "9"));
		}

    </script>	
</head>

<body style="padding:10px;padding-top:0px;">
    
    <h3>DataGrid Wizard - <?php echo $page_name." (".$file_name.")"; ?></h3>

    <form name="frmEditPage" id="frmEditPage" action="datagrid_wizard.php?dgpid=<?php echo $dgpid;?>" method="post">
        <input type="hidden" name="act" value="submit" />
        <input type="hidden" name="file_name" value="<?php echo $file_name;?>" />
       
        <table border="0" cellpadding="2" cellspacing="2" width="760px" style="margin-bottom:5px;">
        <tr valign="top">
            <td><?php echo $msg;?></td>
			<td></td>
        </tr>
		</table>		

		<fieldset style="width:760px;padding:5px; border:#7a7a7a 1px solid;">
		<legend><b>Creating & Calling</b></legend>
        <table align="left" border="0" cellpadding="2" cellspacing="2" width="760px">
	    <tr valign="top">
            <td width="200px">Unique Prefix: (ex.: ABC_)</td>
            <td><input type="text" name="txtUniquePrefix" size="7" maxlength="10" value="<?php echo $txtUniquePrefix; ?>" /></td>
		</tr>       
	    <tr valign="top">
            <td>View Mode table: <font color="#b60000">*</a></td>
            <td>
                <select name="selViewModeTable" id="selViewModeTable" onchange="selViewModeTable_OnChange()">
					<option value="">-- select --</option>
					<?php					
						$sql = "SHOW TABLES FROM ".$config->database;
						$db->query($sql);						
						while($row = $db->fetchArray()) {
							echo "<option ".(($selViewModeTable == $row[0]) ? "selected" : "")." value='".$row[0]."'>".$row[0]."</option>";
						}					
					?>					
				</select>				
            </td>
        </tr>
		</table>
		</fieldset>
		<br />
		
		<fieldset style="width:760px;padding:5px; border:#7a7a7a 1px solid;">
		<legend><b>General Settings</b></legend>
		<table border="0" align="left" cellpadding="2" cellspacing="2" width="100%">
	    <tr valign="top">
            <td width="200px">CSS Class:</td>
            <td>
                <select name="selCssClass">
				<?php				
					$arrCssClass = array("default"=>"Default", "blue"=>"Blue", "gray"=>"Gray", "x-gray"=>"X-gray", "green"=>"Green", "pink"=>"Pink");
					foreach($arrCssClass as $key => $val){
						echo "<option ".(($selCssClass == $key) ? "selected" : "")." value='".$key."'>".$val."</option>";
					}				
				?>
				</select>				
            </td>
        </tr>
		</table>
		</fieldset>
		<br />		
		
		<fieldset style="width:760px;padding:5px; border:#7a7a7a 1px solid;">
		<legend><b>Printing & Exporting Settings</b></legend>
		<table border="0" align="left" cellpadding="2" cellspacing="2" width="100%">
	    <tr valign="top">
            <td width="200px">Allow Printing:</td>
            <td>
                <select name="selPrinting">				
				<?php				
					$arrPrinting = array("false"=>"No", "true"=>"Yes");
					foreach($arrPrinting as $key => $val){
						echo "<option ".(($selPrinting == $key) ? "selected" : "")." value='".$key."'>".$val."</option>";
					}				
				?>
				</select>				
            </td>
        </tr>
	    <tr valign="top">
            <td width="200px">Allow Exporting:</td>
            <td>
                <select name="selExporting">				
				<?php				
					$arrExporting = array("false"=>"No", "true"=>"Yes");
					foreach($arrExporting as $key => $val){
						echo "<option ".(($selExporting == $key) ? "selected" : "")." value='".$key."'>".$val."</option>";
					}				
				?>
				</select>
				&nbsp;&nbsp;&nbsp;
				Export all records:
                <select name="selExportAll">				
				<?php				
					$arrExportAll = array("false"=>"No", "true"=>"Yes");
					foreach($arrExportAll as $key => $val){
						echo "<option ".(($selExportAll == $key) ? "selected" : "")." value='".$key."'>".$val."</option>";
					}				
				?>
				</select>
            </td>
        </tr>
		</table>
		</fieldset>
		<br />		

		<fieldset style="width:760px;padding:5px; border:#7a7a7a 1px solid;">
		<legend><b>Add/Edit/Details Mode Settings</b></legend>
        <table align="left" border="0" cellpadding="2" cellspacing="2" width="760px">
	    <tr valign="top">
            <td width="200px">Add/Edit/Details Mode table: <font color="#b60000">*</a></td>
            <td>
                <select name="selEditModeTable" id="selEditModeTable">
					<option value="">-- select --</option>
					<?php					
						$sql = "SHOW TABLES FROM ".$config->database;
						$db->query($sql);						
						while($row = $db->fetchArray()) {
							echo "<option ".(($selEditModeTable == $row[0]) ? "selected" : "")." value='".$row[0]."'>".$row[0]."</option>";
						}					
					?>					
				</select>				
            </td>
        </tr>
		</table>
		</fieldset>
		<br />

        <table cellpadding="2" cellspacing="2" width="50%">
        <tr valign="top">
            <td></td>
            <td>
				<?php
					if($created){
						echo "<input type='button' name='btnView' value='View' onclick='btnView_OnClick()' />&nbsp;&nbsp;";		
						echo "<input type='button' name='btnSubmit' value='Re-Create DataGrid Page' onclick='btnSubmit_OnClick()' />";								
					}else{
						echo "<input type='button' name='btnCancel' value='Cancel' onclick='btnCancel_OnClick()' />&nbsp;&nbsp;";		
						echo "<input type='button' name='btnSubmit' value='Create DataGrid Page' onclick='btnSubmit_OnClick()' />";		
					}
				?>
                
                
            </td>
        </tr>    
        </table>
    </form>
    
</body>
</html>